; Math.s : 数学関数
;


; モジュール宣言
;
    .module Math

; 参照ファイル
;


; CODE 領域
;
    .area   _CODE

; sin の値を取得する
;
_MathGetSin::
    
    ; レジスタの保存
    push    bc
    push    ix
    
    ; 値の取得
    ld      c, a
    ld      b, #0x00
    ld      ix, #trigonometricDecimalTable
    add     ix, bc
    ld      l, 0(ix)
    ld      ix, #trigonometricIntegerTable
    add     ix, bc
    ld      h, 0(ix)
    
    ; レジスタの復帰
    pop     ix
    pop     bc
    
    ; 終了
    ret

; cos の値を取得する
;
_MathGetCos::
    
    ; レジスタの保存
    push    af
    push    bc
    push    ix
    
    ; 値の取得
    add     a, #0x40
    ld      c, a
    ld      b, #0x00
    ld      ix, #trigonometricDecimalTable
    add     ix, bc
    ld      l, 0(ix)
    ld      ix, #trigonometricIntegerTable
    add     ix, bc
    ld      h, 0(ix)
    
    ; レジスタの復帰
    pop     ix
    pop     bc
    pop     af
    
    ; 終了
    ret

; atan2 の値を取得する
;
_MathGetAtan2::
    
    ; レジスタの保存
    push    hl
    push    bc
    push    de
    
    ; 値の取得
    ld      c, #0x00
    ld      a, l
    sla     l
    rl      c
    bit     #0x00, c
    jr      z, 10$
    neg
    jp      po, 10$
    ld      a, #0x7f
10$:
    ld      l, a
    ld      a, h
    sla     h
    rl      c
    bit     #0x00, c
    jr      z, 11$
    neg
    jp      po, 11$
    ld      a, #0x7f
11$:
    ld      h, a
    cp      l
    jr      nc, 12$
    ld      a, l
12$:
    cp      #0x08
    jr      c, 13$
    sra     a
    sra     h
    sra     l
    jr      12$
13$:
    ld      a, l
    sla     a
    sla     a
    sla     a
    add     a, h
    ld      e, a
    ld      d, #0x00
    ld      hl, #trigonometricAtanAngleTable
    add     hl, de
    ld      a, (hl)
    ld      b, c
    inc     b
    bit     #0x01, b
    jr      z, 14$
    neg
14$:
    ld      b, #0x00
    ld      hl, #trigonometricAtanOffsetTable
    add     hl, bc
    add     a, (hl)
    
    ; レジスタの復帰
    pop     de
    pop     bc
    pop     hl
    
    ; 終了
    ret

; 定数の定義
;

;  三角関数
;
trigonometricDecimalTable:
    
    .db     0x00, 0x06, 0x0c, 0x12, 0x19, 0x1f, 0x25, 0x2b, 0x31, 0x38, 0x3e, 0x44, 0x4a, 0x50, 0x56, 0x5c
    .db     0x61, 0x67, 0x6d, 0x73, 0x78, 0x7e, 0x83, 0x88, 0x8e, 0x93, 0x98, 0x9d, 0xa2, 0xa7, 0xab, 0xb0
    .db     0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0xd4, 0xd8, 0xdb, 0xde, 0xe1, 0xe4, 0xe7, 0xea
    .db     0xec, 0xee, 0xf1, 0xf3, 0xf4, 0xf6, 0xf8, 0xf9, 0xfb, 0xfc, 0xfd, 0xfe, 0xfe, 0xff, 0xff, 0xff
    .db     0x00, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xfc, 0xfb, 0xf9, 0xf8, 0xf6, 0xf4, 0xf3, 0xf1, 0xee
    .db     0xec, 0xea, 0xe7, 0xe4, 0xe1, 0xde, 0xdb, 0xd8, 0xd4, 0xd1, 0xcd, 0xc9, 0xc5, 0xc1, 0xbd, 0xb9
    .db     0xb5, 0xb0, 0xab, 0xa7, 0xa2, 0x9d, 0x98, 0x93, 0x8e, 0x88, 0x83, 0x7e, 0x78, 0x73, 0x6d, 0x67
    .db     0x61, 0x5c, 0x56, 0x50, 0x4a, 0x44, 0x3e, 0x38, 0x31, 0x2b, 0x25, 0x1f, 0x19, 0x12, 0x0c, 0x06
    .db     0x00, 0xfa, 0xf4, 0xee, 0xe7, 0xe1, 0xdb, 0xd5, 0xcf, 0xc8, 0xc2, 0xbc, 0xb6, 0xb0, 0xaa, 0xa4
    .db     0x9f, 0x99, 0x93, 0x8d, 0x88, 0x82, 0x7d, 0x78, 0x72, 0x6d, 0x68, 0x63, 0x5e, 0x59, 0x55, 0x50
    .db     0x4b, 0x47, 0x43, 0x3f, 0x3b, 0x37, 0x33, 0x2f, 0x2c, 0x28, 0x25, 0x22, 0x1f, 0x1c, 0x19, 0x16
    .db     0x14, 0x12, 0x0f, 0x0d, 0x0c, 0x0a, 0x08, 0x07, 0x05, 0x04, 0x03, 0x02, 0x02, 0x01, 0x01, 0x01
    .db     0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x07, 0x08, 0x0a, 0x0c, 0x0d, 0x0f, 0x12
    .db     0x14, 0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28, 0x2c, 0x2f, 0x33, 0x37, 0x3b, 0x3f, 0x43, 0x47
    .db     0x4b, 0x50, 0x55, 0x59, 0x5e, 0x63, 0x68, 0x6d, 0x72, 0x78, 0x7d, 0x82, 0x88, 0x8d, 0x93, 0x99
    .db     0x9f, 0xa4, 0xaa, 0xb0, 0xb6, 0xbc, 0xc2, 0xc8, 0xcf, 0xd5, 0xdb, 0xe1, 0xe7, 0xee, 0xf4, 0xfa

trigonometricIntegerTable:
    
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    .db     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff

trigonometricAtanAngleTable:
    
    .db     0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x40, 0x20, 0x12, 0x0d, 0x09, 0x08, 0x06, 0x05
    .db     0x40, 0x2d, 0x20, 0x17, 0x12, 0x0f, 0x0d, 0x0b
    .db     0x40, 0x32, 0x28, 0x20, 0x1a, 0x16, 0x12, 0x10
    .db     0x40, 0x36, 0x2d, 0x25, 0x20, 0x1b, 0x17, 0x15
    .db     0x40, 0x37, 0x30, 0x29, 0x24, 0x20, 0x1c, 0x19
    .db     0x40, 0x39, 0x32, 0x2d, 0x28, 0x23, 0x20, 0x1c
    .db     0x40, 0x3a, 0x34, 0x2f, 0x2a, 0x26, 0x23, 0x20

trigonometricAtanOffsetTable:
    
    .db     0x00, 0x80, 0x00, 0x80


; DATA 領域
;
    .area   _DATA

; 変数の定義
;

